/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpChannel {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final AtomicReference<HttpExchange> exchange = new AtomicReference();
    private final HttpDestination destination;

    protected HttpChannel(HttpDestination destination) {
        this.destination = destination;
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    public void associate(HttpExchange exchange) {
        if (this.exchange.compareAndSet(null, exchange)) {
            exchange.associate(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} associated to {}", exchange, this);
            }
        } else {
            exchange.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        }
    }

    public HttpExchange disassociate() {
        HttpExchange exchange = this.exchange.getAndSet(null);
        if (exchange != null) {
            exchange.disassociate(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated from {}", exchange, this);
        }
        return exchange;
    }

    public HttpExchange getHttpExchange() {
        return this.exchange.get();
    }

    public abstract void send();

    public abstract void proceed(HttpExchange var1, Throwable var2);

    public abstract boolean abort(Throwable var1);

    public abstract boolean abortResponse(Throwable var1);

    public void exchangeTerminated(Result result) {
        this.disassociate();
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.exchange);
    }
}

