/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.URIUtil;

public class LegacyRule
extends Rule {
    private PathMap _rewrite = new PathMap(true);

    public LegacyRule() {
        this._handling = false;
        this._terminating = false;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PathMap.MappedEntry rewrite = this._rewrite.getMatch(target);
        if (rewrite != null && rewrite.getValue() != null) {
            target = URIUtil.addPaths(rewrite.getValue().toString(), PathMap.pathInfo(rewrite.getKey().toString(), target));
            return target;
        }
        return null;
    }

    public PathMap getRewrite() {
        return this._rewrite;
    }

    public void setRewrite(PathMap rewrite) {
        this._rewrite = rewrite;
    }

    public void addRewriteRule(String pattern, String prefix) {
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        if (this._rewrite == null) {
            this._rewrite = new PathMap(true);
        }
        this._rewrite.put(pattern, prefix);
    }
}

