/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.server;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNServerConnectionFactory
extends NegotiatingServerConnectionFactory {
    private static final Logger LOG = Log.getLogger(ALPNServerConnectionFactory.class);

    public ALPNServerConnectionFactory(String ... protocols) {
        super("alpn", protocols);
        try {
            ClassLoader alpnClassLoader = ALPN.class.getClassLoader();
            if (alpnClassLoader != null) {
                LOG.warn("ALPN must be in the boot classloader, not in: " + alpnClassLoader, new Object[0]);
                throw new IllegalStateException("ALPN must be in the boot classloader");
            }
        }
        catch (Throwable x) {
            LOG.warn("ALPN not available", x);
            throw new IllegalStateException("ALPN not available", x);
        }
    }

    @Override
    protected AbstractConnection newServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        return new ALPNServerConnection(connector, endPoint, engine, protocols, defaultProtocol);
    }
}

