/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class UserAgentFilter
implements Filter {
    private static final String __defaultPattern = "(?:Mozilla[^\\(]*\\(compatible;\\s*+([^;]*);.*)|(?:.*?([^\\s]+/[^\\s]+).*)";
    private Pattern _pattern = Pattern.compile("(?:Mozilla[^\\(]*\\(compatible;\\s*+([^;]*);.*)|(?:.*?([^\\s]+/[^\\s]+).*)");
    private Map<String, String> _agentCache = new ConcurrentHashMap<String, String>();
    private int _agentCacheSize = 1024;
    private String _attribute;

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._attribute != null && this._pattern != null) {
            String ua = this.getUserAgent(request);
            request.setAttribute(this._attribute, ua);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String size;
        this._attribute = filterConfig.getInitParameter("attribute");
        String p = filterConfig.getInitParameter("userAgent");
        if (p != null) {
            this._pattern = Pattern.compile(p);
        }
        if ((size = filterConfig.getInitParameter("cacheSize")) != null) {
            this._agentCacheSize = Integer.parseInt(size);
        }
    }

    public String getUserAgent(ServletRequest request) {
        String ua = ((HttpServletRequest)request).getHeader("User-Agent");
        return this.getUserAgent(ua);
    }

    public String getUserAgent(String ua) {
        if (ua == null) {
            return null;
        }
        String tag = this._agentCache.get(ua);
        if (tag == null) {
            Matcher matcher;
            if (this._pattern != null && (matcher = this._pattern.matcher(ua)).matches()) {
                if (matcher.groupCount() > 0) {
                    for (int g = 1; g <= matcher.groupCount(); ++g) {
                        String group = matcher.group(g);
                        if (group == null) continue;
                        tag = tag == null ? group : tag + group;
                    }
                } else {
                    tag = matcher.group();
                }
            }
            if (tag == null) {
                tag = ua;
            }
            if (this._agentCache.size() >= this._agentCacheSize) {
                this._agentCache.clear();
            }
            this._agentCache.put(ua, tag);
        }
        return tag;
    }
}

