/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.graph;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.deploy.graph.Edge;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.deploy.graph.Path;

public class Graph {
    private Set<Node> _nodes = new HashSet<Node>();
    private Set<Edge> _edges = new HashSet<Edge>();

    public void addEdge(Edge edge) {
        Node toNode;
        Node fromNode = this.getNodeByName(edge.getFrom().getName());
        if (fromNode == null) {
            fromNode = edge.getFrom();
            this.addNode(fromNode);
        }
        if ((toNode = this.getNodeByName(edge.getTo().getName())) == null) {
            toNode = edge.getTo();
            this.addNode(toNode);
        }
        if (edge.getFrom() != fromNode || edge.getTo() != toNode) {
            edge = new Edge(fromNode, toNode);
        }
        this._edges.add(edge);
    }

    public void addEdge(String from, String to) {
        Node toNode;
        Node fromNode = this.getNodeByName(from);
        if (fromNode == null) {
            fromNode = new Node(from);
            this.addNode(fromNode);
        }
        if ((toNode = this.getNodeByName(to)) == null) {
            toNode = new Node(to);
            this.addNode(toNode);
        }
        this.addEdge(fromNode, toNode);
    }

    private void addEdge(Node fromNode, Node toNode) {
        Edge edge = new Edge(fromNode, toNode);
        this.addEdge(edge);
    }

    public void addNode(Node node) {
        this._nodes.add(node);
    }

    public void insertNode(Edge edge, String nodeName) {
        Node node = this.getNodeByName(nodeName);
        if (node == null) {
            node = new Node(nodeName);
        }
        this.insertNode(edge, node);
    }

    public void insertNode(Edge edge, Node node) {
        this.removeEdge(edge);
        this.addNode(node);
        this.addEdge(edge.getFrom(), node);
        this.addEdge(node, edge.getTo());
    }

    public Set<Edge> findEdges(Node node) {
        HashSet<Edge> fromedges = new HashSet<Edge>();
        for (Edge edge : this._edges) {
            if (edge.getFrom() != node && edge.getTo() != node) continue;
            fromedges.add(edge);
        }
        return fromedges;
    }

    public Set<Edge> findEdgesFrom(Node from) {
        HashSet<Edge> fromedges = new HashSet<Edge>();
        for (Edge edge : this._edges) {
            if (edge.getFrom() != from) continue;
            fromedges.add(edge);
        }
        return fromedges;
    }

    public Path getPath(String nodeNameOrigin, String nodeNameDest) {
        if (nodeNameOrigin.equals(nodeNameDest)) {
            return new Path();
        }
        Node from = this.getNodeByName(nodeNameOrigin);
        Node to = this.getNodeByName(nodeNameDest);
        return this.getPath(from, to);
    }

    public Path getPath(Node from, Node to) {
        if (from == to) {
            return new Path();
        }
        Path path = this.breadthFirst(from, to, new CopyOnWriteArrayList<Path>(), new HashSet<Edge>());
        return path;
    }

    private Path breadthFirst(Node from, Node destination, CopyOnWriteArrayList<Path> paths, Set<Edge> seen) {
        boolean edgesAdded = false;
        if (paths.size() == 0) {
            paths.add(new Path());
        }
        for (Path path : paths) {
            Set<Edge> next = this.findEdgesFrom(path.nodes() == 0 ? from : path.lastNode());
            if (next.size() == 0) continue;
            int splits = 0;
            for (Edge edge : next) {
                if (seen.contains(edge)) continue;
                seen.add(edge);
                Path nextPath = ++splits == next.size() ? path : path.forkPath();
                nextPath.add(edge);
                if (destination.equals(edge.getTo())) {
                    return nextPath;
                }
                edgesAdded = true;
                if (nextPath == path) continue;
                paths.add(nextPath);
            }
        }
        if (edgesAdded) {
            return this.breadthFirst(from, destination, paths, seen);
        }
        return null;
    }

    public Set<Edge> getEdges() {
        return this._edges;
    }

    public Node getNodeByName(String name) {
        for (Node node : this._nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public Set<Node> getNodes() {
        return this._nodes;
    }

    public void removeEdge(Edge edge) {
        this._edges.remove(edge);
    }

    public void removeEdge(String fromNodeName, String toNodeName) {
        Node fromNode = this.getNodeByName(fromNodeName);
        Node toNode = this.getNodeByName(toNodeName);
        Edge edge = new Edge(fromNode, toNode);
        this.removeEdge(edge);
    }

    public void removeNode(Node node) {
        this._nodes.remove(node);
    }

    public void setEdges(Set<Edge> edges) {
        this._edges = edges;
    }

    public void setNodes(Set<Node> nodes) {
        this._nodes = nodes;
    }
}

